/* 
 *  Arnold emulator (c) Copyright, Kevin Thacker 1995-2001
 *  
 *  This file is part of the Arnold emulator source code distribution.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <string.h>
#include <ctype.h>
#include <tchar.h>
#include <stdio.h>
#include <stdlib.h>


#include "ifacegen.h"
#include "filetool.h"
#include "global.h"
#include "cpcemu.h"
#include "reg.h"
#include "scrsnap.h"
#include "InterfaceLoadSave.h"
#include "OnScreenDisplay.h"
#include "resource.h"
#include "../../cpc_modified/arnold.h"

#include "../../cpc/host.h"
#include "../../cpc/snapshot.h"
#include "../../cpc/tzx.h"
#include "../../cpc/wav.h"
//#include "../../cpc/dumpym.h"
#include "../../cpc/snapshot.h"
#include "../../cpc/cpc.h"
#include "../../cpc/diskimage/diskimg.h"
#include "../../cpc/audio.h"
#include "../../cpc/asic.h"
#include "../../cpc/joystick.h"

#include <CommCtrl.h>
#include <WinBase.h>

#define BOOL_STR(b) (b?"1":"0")

#ifndef WIN32
#define _stprintf sprintf
#endif

extern APP_DATA AppData;


TCHAR DiskImagePath[MAX_PATH];			/* path for opening disk images */
TCHAR CartridgePath[MAX_PATH];			/* path for opening cartridges */
TCHAR SnapshotPath[MAX_PATH];			/* path for opening snapshots */
TCHAR RomPath[MAX_PATH];				/* path for opening roms */
TCHAR ScreenSnapshotPath[MAX_PATH];		/* path for writing screen snapshots */
TCHAR WavOutputPath[MAX_PATH];			/* path for writing wav recording of sound */
TCHAR AYOutputPath[MAX_PATH];			/* path for writing recording of ay */
TCHAR TapePath[MAX_PATH];				/* path for opening tapes */

TCHAR LastOpenedRom[MAX_PATH];			/* filename of last opened rom */
TCHAR RomFilenames[17][MAX_PATH];		/* filenames of opened roms */
TCHAR DriveFilenames[2][MAX_PATH];		// filename of last disk image opened for drive A
TCHAR CartridgeFilename[MAX_PATH];		/* filename of last opened cartridge */
TCHAR CheatFilename[MAX_PATH];			/* filename of cheat database */
TCHAR SnapshotFilename[MAX_PATH];		/* filename of last opened/saved snapshot */
TCHAR WavOutputFilename[MAX_PATH];		/* filename of last wav recording */
TCHAR AYOutputFilename[MAX_PATH];		/* filename of last AY recording */
TCHAR DriveAFilename[MAX_PATH];		/* filename of last disk image opened for drive A */
TCHAR DriveBFilename[MAX_PATH];		/* filename of last disk image opened for drive B */
TCHAR TapeFilename[MAX_PATH];			/* filename of last tape opened */
TCHAR Multiface_CPC_ROM_Filename[MAX_PATH];			/* filename of CPC version of multiface rom */
TCHAR Multiface_CPCPLUS_ROM_Filename[MAX_PATH];		/* filename of CPC+ version of multiface rom */

int BasicCPCtype;
int BasicCRTCtype;
CPC_MONITOR_TYPE_ID BasicMonitortype;

BOOL fShowQuit;
BOOL fShowReset;

int accuracyLevel;
BOOL Host_LockSpeed;
BOOL SpeedDrive;
BOOL Slowdown;
BOOL Hack_Synchrosound;
BOOL Parados_enabled;
short BoostZ80;

//from cpcemu.c
BOOL	CPCEMU_DetectFileAndLoad(const TCHAR *pFilename);

//snapshoot
SNAPSHOT_OPTIONS Options;

//audio
void Set_Master_Volume(short vol);
short Get_Master_Volume(void);

/*------------------------------------------------------------------------------------------*/
/* set a string */

void	SetString(TCHAR **ppReplaceString, const TCHAR *pSourceString)
{
	TCHAR *pDestString = *ppReplaceString;

	/* string defined? */
	if (pDestString!=NULL)
	{
		/* free it */
		free(pDestString);
	}

	pDestString = NULL;

	/* quit if new string is not defined */
	if (pSourceString!=NULL)
	{
		int nStringLenBytes = (_tcslen(pSourceString)+1)*sizeof(TCHAR);

		/* allocate for new string */
		pDestString = (TCHAR *)malloc(nStringLenBytes);

		if (pDestString)
		{
			memcpy(pDestString, pSourceString, nStringLenBytes);
		}
	}

	*ppReplaceString = pDestString;
}
/*------------------------------------------------------------------------------------------*/
#if 0
int Multiface_LoadRomFromFile(const MULTIFACE_ROM_TYPE RomType, const TCHAR *pFilename)
{
    unsigned long   RomSize;
    unsigned char   *pRomData;
	int Status;

    /* attempt to load rom data */
    LoadFile((TCHAR *)pFilename,&pRomData, &RomSize);

	if (pRomData!=NULL)
	{
		Status = Multiface_SetRomData(RomType, pRomData, RomSize);

		free(pRomData);
	}

	return Status;
}
#endif
/*------------------------------------------------------------------------------------------*/


void GenericInterface_Initialise(void)
{

	LastOpenedRom[0]=0;
	DriveAFilename[0]=0;
	DriveBFilename[0]=0;
	/*
	int i;

	DiskImagePath = NULL;			
	CartridgePath = "";			
	SnapshotPath = "";			
	RomPath = "";					
	ScreenSnapshotPath = "";		
	WavOutputPath = "";			
	AYOutputPath = "";			
	TapePath = "";				

	CartridgeFilename = "";		
	SnapshotFilename = "";		
	WavOutputFilename = "";		
	AYOutputFilename = "";		
	DriveAFilename = "";			
	DriveBFilename = "";			
	TapeFilename = "";			
	Multiface_CPC_ROM_Filename = "";	
	Multiface_CPCPLUS_ROM = "";		

	for (i=0; i<2; i++)
	{
		DriveFilenames[i] = "";
	}


	for (i=0; i<17; i++)
	{
		RomFilenames[i] = "";
	}
	*/
}

#if 0
BOOL DiskImage_InsertFormattedDisk(int DriveID, const TCHAR *Filename)
{
	unsigned char *pDiskImage;
	unsigned long DiskImageLength;

    /* load disk image file to memory */
    LoadFile(Filename, &pDiskImage, &DiskImageLength);

	if (pDiskImage!=NULL)
	{
		BOOL bStatus;

		bStatus = DiskImage_InsertDisk(DriveID, pDiskImage, DiskImageLength);

		free(pDiskImage);
	
		return bStatus;
	}

	return FALSE;
}
#endif


BOOL	ExpansionRom_Insert(const TCHAR *FilenameBuffer, const int RomIndex)
{
	unsigned char *pRomData;
	unsigned long RomDataSize;

	LoadFile(FilenameBuffer, &pRomData, &RomDataSize);
	if (pRomData!=NULL)
	{
		
		//ExpansionRom_SetRomData(pRomData, RomDataSize, RomIndex);
	
		free(pRomData);

		return TRUE;
	}

	return FALSE;
}

BOOL	GenericInterface_LoadRom(int RomIndex, const TCHAR *FilenameBuffer)
{
	if (FilenameBuffer!=NULL)
	{
		if (strlen(FilenameBuffer)!=0)
		{
			if (ExpansionRom_Insert(FilenameBuffer, RomIndex))
			{
				const TCHAR *pPath;
				const TCHAR *pFile;

				pPath = GetPathFromPathAndFilename(FilenameBuffer);
				strcpy(RomPath, pPath);
				//SetString(&RomPath, pPath);
				
				pFile = GetFilenameFromPathAndFilename(FilenameBuffer);
				strcpy(RomFilenames[RomIndex],FilenameBuffer);
				//SetString(&RomFilenames[RomIndex],FilenameBuffer);

				return TRUE;
			}
		}
	}

	return FALSE;
}

/*
void	GenericInterface_RestoreRomSettings(void)
{
	int i;

	for (i=1; i<17; i++)
	{
		TCHAR SettingsKey[32];
		TCHAR *pCurrentRomFilename;
		
		// setup settings key
		_stprintf(SettingsKey, "sRom%2d", i);
		
		MyApp_Registry_GetString(const TCHAR * Key, const TCHAR *ValueName, pCurrentRomFilename);
	
		// string present for this key, or key present ?
		if (pCurrentRomFilename != NULL)
		{
			// string exists

			if (strlen(pCurrentRomFilename)!=0)
			{
				if (GenericInterface_LoadRom(i, pCurrentRomFilename))
				{
					int ActiveFlag;

					// if it's active in settings, make it active
					_stprintf(SettingsKey,_T("iRom%2dActive"),i);

					// get active state
					ActiveFlag = MyApp_Registry_GetIntFromCurrentKey(SettingsKey);

					if (ActiveFlag != 0)
					{
						ExpansionRom_SetActiveState(i, TRUE);
					}
					else
					{
						ExpansionRom_SetActiveState(i, FALSE);
					}
				}
			}
		}
	}
}
*/
static  TCHAR *EmptyString = _T("");
/*
void	GenericInterface_StoreRomSettings(void)
{
	int i;

	for (i=1; i<17; i++)
	{
		TCHAR SettingsKey[32];
		const TCHAR *pCurrentRomFilename;
				
		// get filename of rom in slot i
		pCurrentRomFilename = RomFilenames[i];
			
		// initialise settings key
		_stprintf(SettingsKey, "sRom%2d", i);
		
		if (pCurrentRomFilename!=NULL)
		{
			// store filename if specified - i.e. rom was inserted
			MyApp_Registry_StoreStringToCurrentKey(SettingsKey, pCurrentRomFilename);

			// store if rom is active or not
			{
				_stprintf(SettingsKey,_T("iRom%2dActive"), i);

					MyApp_Registry_StoreIntToCurrentKey(SettingsKey, ExpansionRom_IsActive(i));
			}
		}
		else
		{
			// store empty string, no rom specified
			MyApp_Registry_StoreStringToCurrentKey(SettingsKey, EmptyString);
		}
	}
}
*/
BOOL	Snapshot_Load(const TCHAR *SnapshotFilename)
{
	unsigned char *pSnapshotData;
	unsigned long SnapshotDataLength;

	LoadFile(SnapshotFilename, &pSnapshotData, &SnapshotDataLength);

	if (pSnapshotData!=NULL)
	{
		BOOL bStatus;

		SNAPSHOT_MEMORY_BLOCKS SnapshotMemoryBlocks;
		Snapshot_CollectMemory(&SnapshotMemoryBlocks, SnapshotSettings_GetDefault(), TRUE);
		bStatus = Snapshot_Insert(pSnapshotData, SnapshotDataLength,&SnapshotMemoryBlocks);

		free(pSnapshotData);
	
		return bStatus;
	}

	return FALSE;
}


BOOL	GenericInterface_LoadSnapshot(const TCHAR *FilenameBuffer)
{
	if (FilenameBuffer!=NULL)
	{
		if (strlen(FilenameBuffer)!=0)
		{
			const TCHAR *pPath, *pFile;

			pPath = GetPathFromPathAndFilename(FilenameBuffer);

			//SetString(&SnapshotPath, pPath);
			strcpy(SnapshotPath, pPath);
			
			if (Snapshot_Load(FilenameBuffer))
			{
				pFile = GetFilenameFromPathAndFilename(FilenameBuffer);
			
				//SetString(&SnapshotFilename, pFile);
				strcpy(SnapshotFilename, pFile);

				return TRUE;
			}
		}
	}

	return FALSE;
}


BOOL GenericInterface_SnapshotSave(const TCHAR *FilenameBuffer)
{
	const TCHAR *pPath;
	unsigned long nLength;
	unsigned char *pSnapshotData = NULL;
	SNAPSHOT_OPTIONS SnapshotOptions;

	SNAPSHOT_MEMORY_BLOCKS MemoryBlocks;
	Snapshot_CollectMemory(&MemoryBlocks, &Options, TRUE);

	pPath = GetPathFromPathAndFilename(FilenameBuffer);

	strcpy(SnapshotPath, pPath);
	
    SnapshotOptions.Version = SnapshotSettings_GetVersion(&Options);
    SnapshotOptions.bCompressed = SnapshotSettings_GetCompressed(&Options);
	SnapshotSettings_SetSizeToExport(&SnapshotOptions,(SNAPSHOT_SIZE)8);

    nLength = Snapshot_CalculateEstimatedOutputSize(&SnapshotOptions,&MemoryBlocks);

	pSnapshotData = (unsigned char *)malloc(nLength);

	if (pSnapshotData!=NULL)
	{
		unsigned long nActualLength = Snapshot_GenerateOutputData(pSnapshotData, &SnapshotOptions,&MemoryBlocks);

		SaveFile(FilenameBuffer, pSnapshotData, nActualLength);
	
		free(pSnapshotData);
	}

	return TRUE;
}


BOOL GenericInterface_SaveScreenSnapshot(const TCHAR *FilenameBuffer,BOOL thumb)
{
	if (FilenameBuffer!=NULL)
	{
		if (strlen(FilenameBuffer)!=0)
		{
			char tmp[MAX_PATH+20];
			const TCHAR *pPath;

			pPath = GetPathFromPathAndFilename(FilenameBuffer);
			strcpy(ScreenSnapshotPath,pPath);
			//SetString(&ScreenSnapshotPath, pPath);
	
			if (Screen_SaveSnapshot(FilenameBuffer,thumb))
			{
				if (!thumb)
				{
					wsprintf(tmp,"Saving ScreenShoot : %s",FilenameBuffer);
					SetInfoMessage(tmp);
				}

				return TRUE;
			}
			else
			{
				wsprintf(tmp,"Error Can't save : %s",FilenameBuffer);
				SetInfoMessage(tmp);
			}
		
		}
	}

	return FALSE;
}


BOOL TapeImage_InsertFromFile(const TCHAR *Filename)
{
	unsigned char *pTapeImage;
	unsigned long TapeImageLength;

	LoadFile(Filename, &pTapeImage, &TapeImageLength);

	if (pTapeImage!=NULL)
	{
		BOOL bStatus;

		bStatus = TapeImage_Insert(pTapeImage, TapeImageLength);

		free(pTapeImage);
	
		return bStatus;
	}

	return FALSE;
}


BOOL	GenericInterface_InsertTape(TCHAR *FilenameBuffer)
{
	if (FilenameBuffer!=NULL)
	{
		if (strlen(FilenameBuffer)!=0)
		{
			const TCHAR *pPath,  *pFile;

			pPath = GetPathFromPathAndFilename(FilenameBuffer);

			//SetString(&TapePath, pPath);
			strcpy(TapePath, pPath);

			// attempt tape first
			if (TapeImage_InsertFromFile(FilenameBuffer))
			{
				pFile = GetFilenameFromPathAndFilename(FilenameBuffer);
				//SetString(&TapeFilename, pFile);
				strcpy(TapeFilename, pFile);
				
				return TRUE;
			}

			// now attempt samples..
			if (Sample_Load(FilenameBuffer))
			{
				pFile = GetFilenameFromPathAndFilename(FilenameBuffer);
				strcpy(TapeFilename, pFile);
				//SetString(&TapeFilename, pFile);
			
				return TRUE;
			}

		}
	}

	return FALSE;
}

BOOL	Cartridge_Load(const TCHAR *pFilename)
{
	unsigned char *pCartridgeData;
	unsigned long CartridgeLength;

	LoadFile(pFilename, &pCartridgeData, &CartridgeLength);

	if (pCartridgeData!=NULL)
	{
		int Status;

		Status = Cartridge_Insert(pCartridgeData, CartridgeLength);

		Cartridge_Autostart();

		free(pCartridgeData);
		return (Status==ARNOLD_STATUS_ROM_OK);
	}

	return FALSE;
}

BOOL	GenericInterface_InsertCartridge(const TCHAR *FilenameBuffer)
{
	if (FilenameBuffer!=NULL)
	{
		if (strlen(FilenameBuffer)!=0)
		{
			const TCHAR *pPath, *pFile;

			pPath = GetPathFromPathAndFilename(FilenameBuffer);
			strcpy(CartridgePath, pPath);
			//SetString(&CartridgePath, pPath);
	
			/* load cartridge */
			if (Cartridge_Load(FilenameBuffer))
			{
				pFile = GetFilenameFromPathAndFilename(FilenameBuffer);
				strcpy(CartridgeFilename, pFile);
				//SetString(&CartridgeFilename, pFile);
				return TRUE;
			}
		}
	}

	/* cartridge failed to load */
	return FALSE;
}



void CheckOption_validity(void)
{
	char folder[MAX_PATH];
	GetModulePath(folder);

	if (!FolderExist(DiskImagePath)) wsprintf(DiskImagePath,"%s%s",folder,"\\DSK\\");
	if (!FolderExist(CartridgePath)) wsprintf(CartridgePath,"%s%s",folder,"\\Cartridge\\");
	if (!FolderExist(SnapshotPath)) wsprintf(SnapshotPath,"%s%s",folder,"\\Snaps\\");
	if (!FolderExist(TapePath)) wsprintf(TapePath,"%s%s",folder,"\\Tape\\");
	if (!FolderExist(ScreenSnapshotPath)) wsprintf(ScreenSnapshotPath,"%s%s",folder,"\\Screenshoot\\");
	if (!FolderExist(RomPath)) wsprintf(RomPath,"%s%s",folder,"\\Rom\\");
}

void GenericInterface_RemoveCartridge(void)
{
	/* remove old cartridge */
	Cartridge_Remove();
}

void GenericInterface_RestoreSettings(void)
{
	char buffer[255];
	short v = 0;

	/* restore stored settings */

	// restore CPC type
	BasicCPCtype = MyApp_Registry_GetValue("BASIC", "CPC_Type");

	/* restore CRTC type */
	BasicCRTCtype = MyApp_Registry_GetValue("BASIC", "CRTCType");

	/* restore monitor type */
	BasicMonitortype = (CPC_MONITOR_TYPE_ID)MyApp_Registry_GetValue("BASIC", "MonitorType");

	/* restore accuracy size for windowed */
	accuracyLevel = MyApp_Registry_GetValue("BASIC", "Accuracy_Level");
		
	/* restore Boost z80 */
	BoostZ80 = (short)MyApp_Registry_GetValue("BASIC", "Boost_Z80");

	/* restore Master volume */
	v = (short)MyApp_Registry_GetValue("BASIC", "Master_Volume");
	if (v == 0) v = 100;
	Set_Master_Volume(v);

	/* restore monitor brightness */
	//CPC_SetMonitorBrightness(MyApp_Registry_GetValue("BASIC", "MonitorBrightnesse"));		

		/* restore printer output method */
//		if (Settings_IsKeyPresent(_T("iPrinterOutputMethod")))
//		{
//			Printer_SetOutputMethod(MyApp_Registry_GetIntFromCurrentKey(_T("iPrinterOutputMethod")));
//		}

	/* restore cheat database file path */
	MyApp_Registry_GetString("BASIC", "CheatFilename", CheatFilename);

	/* restore frame skip settings */
	CPC_SetFrameSkip(MyApp_Registry_GetValue("BASIC", "FrameSkip"));
		
	/* restore cartridge path */
	MyApp_Registry_GetString("PATH", "CartridgePath", CartridgePath);
		
	/* restore disk image path */
	MyApp_Registry_GetString("PATH", "DiskImagePath", DiskImagePath);
		
	/* restore screen snapshot path */
	MyApp_Registry_GetString("PATH", "ScreenSnapshotPath", ScreenSnapshotPath);

	/* restore wave output settings */
	MyApp_Registry_GetString("PATH", "WavOutputPathh", WavOutputPath);

	/* restore snapshot path */
	MyApp_Registry_GetString("PATH", "SnapshotPath", SnapshotPath);
		
	/* restore AY/PSG output path */
	MyApp_Registry_GetString("PATH", "AYOutputPath", AYOutputPath);
		
	/* restore rom path */
	MyApp_Registry_GetString("PATH", "RomPath", RomPath);
		
	/* restore tape image path */
	MyApp_Registry_GetString("PATH", "TapePath", TapePath);

	// restore Real Time
	MyApp_Registry_GetString("BASIC", "Real_Time",buffer);
	Host_LockSpeed = (*buffer == '1');

	// restore Speed drive
	MyApp_Registry_GetString("BASIC", "Speed_Drive",buffer);
	SpeedDrive = (*buffer == '1');

	// restore Hack sound synchronise
	MyApp_Registry_GetString("BASIC", "Hack_SoundSynchro",buffer);
	Hack_Synchrosound = (*buffer == '1');

	// restore Parados
	MyApp_Registry_GetString("BASIC", "Parados_enabled",buffer);
	Parados_enabled = (*buffer == '1');

	//restore fullscreen resolution
	AppData.FullScreenHeight=MyApp_Registry_GetValue("DISPLAY", "Height");
	AppData.FullScreenWidth=MyApp_Registry_GetValue("DISPLAY", "Width");
	MyApp_Registry_GetString("DISPLAY", "Windowed",buffer);
	AppData.Windowed = (*buffer == '1');
	MyApp_Registry_GetString("DISPLAY", "FakeFS", buffer);
	AppData.FakeFS = (*buffer == '1');

	/* restore roms */
	//GenericInterface_RestoreRomSettings();

#if 0
	/* restore disk images */
	if (strlen(GetCommandLine()) == 0)
	{
		MyApp_Registry_GetString("BASIC", "DriveADiskImag" , buffer);
		if (strlen(buffer)>0) Interface_InsertDiskFromFile(0,buffer);
		MyApp_Registry_GetString("BASIC", "DriveBDiskImag" , buffer);
		if (strlen(buffer)>0)Interface_InsertDiskFromFile(1,buffer);
	}
#endif

	// restore warm exit
	MyApp_Registry_GetString("BASIC", "Warm_Exit",buffer);
	fShowQuit = (*buffer == '1');

	// restore warm reset
	MyApp_Registry_GetString("BASIC", "Warm_Exit",buffer);
	fShowReset = (*buffer == '1');

	CheckOption_validity();
	
}


void GenericInterface_StoreSettings(void)
{
	/* store current settings */

		// store CPC type
		MyApp_Registry_SetValue("BASIC", "CPC_Type", CPC_GetCPCType());

		/* store CRTC type */
	    MyApp_Registry_SetValue("BASIC", "CRTCType", CPC_GetCRTCType());

		/* store monitor type */
		MyApp_Registry_SetValue("BASIC", "MonitorType", CPC_GetMonitorType());

		/* store monitor brightness */
		//MyApp_Registry_SetValue("BASIC", "MonitorBrightness", CPC_GetMonitorBrightness());

		/* store accuracy size for windowed */
		MyApp_Registry_SetValue("BASIC", "Accuracy_Level",accuracyLevel);

		/* store Boost z80 */
		MyApp_Registry_SetValue("BASIC", "Boost_Z80",BoostZ80);

		/* store Master volume */
		MyApp_Registry_SetValue("BASIC", "Master_Volume",Get_Master_Volume());

		/* store printer output method */
//			MyApp_Registry_StoreIntToCurrentKey(_T("iPrinterOutputMethod"), Printer_GetOutputMethod());

		/* store frame skip */
		MyApp_Registry_SetValue("BASIC", "FrameSkip", CPC_GetFrameSkip());

		/* store cartridge path */
		MyApp_Registry_SetString("PATH", "CartridgePath" , CartridgePath);

		/* store disk image path */
		MyApp_Registry_SetString("PATH", "DiskImagePath", DiskImagePath);

		/* store screen snapshot path */
		MyApp_Registry_SetString("PATH", "ScreenSnapshotPath", ScreenSnapshotPath);

		/* store snapshot path */
		MyApp_Registry_SetString("PATH", "SnapshotPath", SnapshotPath);

		/* store wave output path */
		MyApp_Registry_SetString("PATH", "sWavOutputPath", WavOutputPath);

		/* store AY output path */
		MyApp_Registry_SetString("PATH", "AYOutputPath", AYOutputPath);

		/* store tape image path */
		MyApp_Registry_SetString("PATH", "TapePath", TapePath);

		/* store rom path */
		MyApp_Registry_SetString("PATH", "RomPath", RomPath);

		/* store full path and filename for disk image that has been inserted */
		MyApp_Registry_SetString("BASIC", "DriveADiskImage", DriveAFilename);

		/* store full path and filename for disk image that has been inserted */
		MyApp_Registry_SetString("BASIC", "DriveBDiskImage", DriveBFilename);

		/* store full path and filename for cartridge that has been inserted */
		MyApp_Registry_SetString("BASIC", "Cartridge", CartridgeFilename);

		/* store full path and filename for Cheat Database */
		MyApp_Registry_SetString("BASIC", "CheatFilename", CheatFilename);

		// store Real Time
		MyApp_Registry_SetString("BASIC", "Real_Time",BOOL_STR(Host_LockSpeed));

		// store Speed drive
		MyApp_Registry_SetString("BASIC", "Speed_Drive",BOOL_STR(SpeedDrive));

		// store Hach Sound Synchro
		MyApp_Registry_SetString("BASIC", "Hack_SoundSynchro",BOOL_STR(Hack_Synchrosound));

		// store Parados
		MyApp_Registry_SetString("BASIC", "Parados_enabled",BOOL_STR(Parados_enabled));
		
		// store warm exit
		MyApp_Registry_SetString("BASIC", "Warm_Exit",BOOL_STR(fShowQuit));

		// store warm reset
		MyApp_Registry_SetString("BASIC", "Warm_Exit",BOOL_STR(fShowReset));

		// store fullscreen resolution
		MyApp_Registry_SetValue("DISPLAY", "Height", AppData.FullScreenHeight);
		MyApp_Registry_SetValue("DISPLAY", "Width", AppData.FullScreenWidth);
		MyApp_Registry_SetString("DISPLAY", "Windowed", BOOL_STR(AppData.Windowed));
		MyApp_Registry_SetString("DISPLAY", "FakeFS", BOOL_STR(AppData.FakeFS));

		/* store roms that were loaded */
		//GenericInterface_StoreRomSettings();
		/* close settings */
	
}


//**********************************************************************************************************
//		RECENT FILE

/*----------------------------------------------------------------------------------------------*/

RECENT_ITEMS RecentFiles;

/*----------------------------------------------------------------------------------------------*/
/* recent list id must be 0 based and all lists must be contiguous */
/* the idea here is that there can be multiple recent lists for tapes,discs,cartridges etc */
/*
RECENT_ITEMS *RecentItems_GetItemsList(int nRecentListID)
{
	return &RecentFiles;
}
*/
/*----------------------------------------------------------------------------------------------*/
void RecentFiles_Init(void)
{
	int i;

	RecentFiles.nItems = 0;
	for (i=0; i<MAX_RECENT_ITEMS; i++)
	{
		RecentFiles.Items[i].sDisplayName[0] = '\0';
		RecentFiles.Items[i].sFilename[0] = '\0';
	}
}

/*----------------------------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------------------------*/
void RecentFiles_Free(int nIndex)
{
	int i;
	RecentFiles.Items[nIndex].sDisplayName[0] = 0;
	RecentFiles.Items[nIndex].sFilename[0] = 0;
	for (i=nIndex; i<MAX_RECENT_ITEMS; i++)
	{
		strncpy(RecentFiles.Items[i].sFilename,RecentFiles.Items[i+1].sFilename,MAX_PATH);
		strncpy(RecentFiles.Items[i].sDisplayName,RecentFiles.Items[i+1].sDisplayName,MAX_PATH);
	}
	RecentFiles.Items[MAX_RECENT_ITEMS].sDisplayName[0] = '0';
	RecentFiles.Items[MAX_RECENT_ITEMS].sFilename[0] = '0';

	RecentFiles.nItems-=1;
}


/*----------------------------------------------------------------------------------------------*/
/* find item by filename */
int RecentFiles_Find(LPCTSTR sFilename)
{
	int i;
	for (i=0; i<RecentFiles.nItems; i++)
	{
		/* compare filenames */
		if(strcmp (sFilename,RecentFiles.Items[i].sFilename) == 0) return i;
	}

	return -1;
}

/*----------------------------------------------------------------------------------------------*/
/* remove item. Do this if we try to load the file and it can't be loaded */
void RecentFiles_Remove(LPCTSTR sFilename)
{
	int nIndex;

	/* find the item */
	nIndex = RecentFiles_Find(sFilename);

	if (nIndex==-1)
		return;

	/* free the item */
	RecentFiles_Free(nIndex);
}

/*----------------------------------------------------------------------------------------------*/
/* if the item already exists in the list, promote it to the top */
/* if the item doesn't exist, insert it at the top */
void RecentFiles_Add(LPCTSTR sFilename)
{
	//char *DisplayName[MAX_PATH];		/* the display name in the UI */
	//LPTSTR sCopiedFilename = NULL;	/* the duplicated filename */
	int nItemsEnd = 0; /* number of items to move down list */
	int nItemsStart = 0; /* position to start copying to*/
	int nItem;
	int i;

	if (_tcslen(sFilename)==0)
		return;

	nItem = RecentFiles_Find(sFilename);

	if (nItem == -1)
	{
		if (RecentFiles.nItems >= MAX_RECENT_ITEMS)
		{
			//too much files >> roll up
			for (i=0; i<MAX_RECENT_ITEMS-1; i++)
			{
				strncpy(RecentFiles.Items[i].sFilename,RecentFiles.Items[i+1].sFilename,MAX_PATH);
				strncpy(RecentFiles.Items[i].sDisplayName,RecentFiles.Items[i+1].sDisplayName,MAX_PATH);
			}
			RecentFiles.nItems-=1;
		}
		strncpy(RecentFiles.Items[RecentFiles.nItems].sFilename,sFilename,MAX_PATH);
		strncpy(RecentFiles.Items[RecentFiles.nItems].sDisplayName,GetFilenameFromPathAndFilename(sFilename),MAX_PATH);
		RecentFiles.nItems+=1;
	}
	else
	{
		strncpy(RecentFiles.Items[nItem].sFilename,RecentFiles.Items[7].sFilename,MAX_PATH);
		strncpy(RecentFiles.Items[nItem].sDisplayName,RecentFiles.Items[7].sDisplayName,MAX_PATH);
		strncpy(RecentFiles.Items[7].sFilename,sFilename,MAX_PATH);
		strncpy(RecentFiles.Items[7].sDisplayName,GetFilenameFromPathAndFilename(sFilename),MAX_PATH);
	}

}

/*----------------------------------------------------------------------------------------------*/
HMENU RecentFiles_GetFileMenu(HWND hwnd)
{
	HMENU hMainMenu;

	/* get the menu of this window */
	hMainMenu= GetMenu(hwnd);

	if (hMainMenu)
	{
		return GetSubMenu(hMainMenu, 0);
	}

	return (HMENU)0;
}

/*----------------------------------------------------------------------------------------------*/
void RecentFiles_EnableMenu(HWND hwnd, BOOL fEnable)
{
	HMENU hFileMenu = RecentFiles_GetFileMenu(hwnd);
	UINT uEnable = MF_BYPOSITION;
	if (fEnable)
		uEnable |= MF_ENABLED;
	else
		uEnable |= MF_GRAYED;

	EnableMenuItem(hFileMenu, RECENT_ITEMS_FIRST_MENU_POS, uEnable);
}

/*----------------------------------------------------------------------------------------------*/
HMENU RecentFiles_GetMenu(HWND hwnd)
{
	HMENU hFileMenu = RecentFiles_GetFileMenu(hwnd);

	if (hFileMenu)
	{
		return GetSubMenu(hFileMenu, RECENT_ITEMS_FIRST_MENU_POS);
	}

	return (HMENU)0;
}

/*----------------------------------------------------------------------------------------------*/
void RecentFiles_RefreshMenu(HWND hwnd)
{
	int i;
	HMENU hRecentMenu;

	RecentFiles_EnableMenu(hwnd,RecentFiles.nItems);
	if (RecentFiles.nItems!=0)
	{
		TCHAR sMenuItem[256];
		// get handle to recent sub menu
		hRecentMenu = RecentFiles_GetMenu(hwnd);

		// initially delete all items
		for (i=GetMenuItemCount(hRecentMenu)-1; i>=0; i--)
		{
			DeleteMenu(hRecentMenu, i, MF_BYPOSITION);
		}

		// now fill with new items
		for (i = 0; i < RecentFiles.nItems; i++)
		{
			// format string for menu item
			wsprintf(sMenuItem,_T("&%d %s"),(i+1),RecentFiles.Items[i].sDisplayName);
			InsertMenu(hRecentMenu,i, MF_BYPOSITION|MF_STRING, i+1, sMenuItem);
		}
	}
}

/*----------------------------------------------------------------------------------------------*/
void RecentFiles_AddAndRefresh(HWND hwnd,LPCTSTR sFilename, int nRecentListID)
{
	RecentFiles_Add(sFilename);
	RecentFiles_RefreshMenu(hwnd);
}
/*----------------------------------------------------------------------------------------------*/
void RecentFiles_Restore(LPCTSTR sPrefix)
{
	int i;

		for (i=0; i<MAX_RECENT_ITEMS; i++)
		{
			TCHAR sKey[256];
			TCHAR sFilename[MAX_PATH];

			_stprintf(sKey,"%s%d","Recent_", i);
			MyApp_Registry_GetString("RECENT", sKey, sFilename);

			if (sFilename!=NULL)
			{
				if (_tcslen(sFilename)!=0)
				{
					RecentFiles_Add(sFilename);
				}
			}
		
	}
}
/*----------------------------------------------------------------------------------------------*/
void RecentFiles_Store(int nRecentListID, LPCTSTR sPrefix)
{

	int i;
	
	for (i=0; i< RecentFiles.nItems; i++)
	{
		TCHAR sKey[256];
		_stprintf(sKey,"%s%d","Recent_", i);
		MyApp_Registry_SetString("RECENT", sKey, RecentFiles.Items[i].sFilename);
	}

}

//---------------------------------------------------------------------------------------------------
/* returns TRUE if this is an item from one of the recent lists */
BOOL RecentItems_Handle(WORD wID)
{
	int nRecentItem;
	char tmp[255];

	if (wID>(MAX_RECENT_ITEMS))
		return FALSE;

	nRecentItem = (wID-1)%MAX_RECENT_ITEMS;

	if (nRecentItem > RecentFiles.nItems)
	return FALSE;

	if (RecentFiles.Items[nRecentItem].sFilename[0] == '\0') return FALSE;

	if (CPCEMU_DetectFileAndLoad(RecentFiles.Items[nRecentItem].sFilename) == TRUE)
	{
		char tmpfile[MAX_PATH];
		strncpy(tmpfile,RecentFiles.Items[nRecentItem].sFilename,MAX_PATH);

		wsprintf(tmp,"loading Disk : %s",tmpfile);
		SetInfoMessage(tmp);

		strcpy(LastOpenedRom,tmpfile);

		RecentFiles_AddAndRefresh(AppData.ApplicationHwnd, tmpfile, RECENT_LIST_FILES);

	}
	else
	{
		SetInfoMessage("Sorry - Loading failed");
		return FALSE;
	}


	return TRUE;
}


//*************************************************************************************************************************
// CONFIG DIALOG
//***********************************************************************************************************************

int CALLBACK SpeedPropertySheet_DialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
		case WM_INITDIALOG:
		{
			HWND htb;
			SCROLLINFO si;

			if (Host_LockSpeed) CheckDlgButton(hwndDlg, IDC_CHECK_REALTIME, BST_CHECKED);
			if (Slowdown) CheckDlgButton(hwndDlg, IDC_CHECK_SLOWDOWN, BST_CHECKED);

			htb = GetDlgItem(hwndDlg, IDC_BOOST_Z80); 
			SendMessage(htb, TBM_SETRANGE,FALSE, MAKELONG(0, 4));
			//SendMessage(htb, TBM_SETSEL,FALSE, MAKELONG(1, 2));
			//SendMessage(htb, TBM_SETTICFREQ, 1, 0);
			SendMessage(htb, TBM_SETPOS,TRUE, BoostZ80); 
			SetDlgItemInt(hwndDlg, IDC_BOOST_Z80, BoostZ80, FALSE);

			htb = GetDlgItem(hwndDlg, IDC_SCROLLBAR1); 
            ZeroMemory(&si, sizeof(SCROLLINFO)); 
            si.cbSize = sizeof(si); 
            si.fMask  = SIF_RANGE | SIF_POS; 
            si.nMin   = 0; 
            si.nMax   = 10; 
            si.nPos   = CPC_GetFrameSkip(); 
            SetScrollInfo(htb, SB_CTL, &si, FALSE); 

			SetDlgItemInt(hwndDlg, IDC_EDIT1, CPC_GetFrameSkip(), FALSE); 

			return TRUE;
			
		}
		break;
/*
		case WM_HSCROLL: 
		{
			HWND htb;
			htb = GetDlgItem(hwndDlg, IDC_BOOST_Z80);
			SetDlgItemInt(hwndDlg, IDC_EDIT1, SendMessage(htb, TBM_GETPOS, 0, 0), FALSE); 
			return TRUE; 
		}
			break;
*/
		      case WM_VSCROLL:
				  {
					 SCROLLINFO si;
					 HWND htb;

					 ZeroMemory(&si, sizeof(SCROLLINFO)); 
					 si.cbSize = sizeof(si);
					 si.fMask  = SIF_RANGE | SIF_POS;
					
					 htb = GetDlgItem(hwndDlg, IDC_SCROLLBAR1);
					 GetScrollInfo(htb, SB_CTL, &si); 

					 switch (LOWORD(wParam))
					   { 

						case SB_PAGEUP: 
							si.nPos -= 2; 
							if(si.nPos < si.nMin) si.nPos = si.nMin ; 
							break; 
						  case SB_PAGEDOWN: 
							si.nPos += 2; 
							if(si.nPos > si.nMax) si.nPos = si.nMax ; 
							break; 
						  case SB_LINEDOWN: 
							if(si.nPos > si.nMin) si.nPos--; 
							break; 
						  case SB_LINEUP: 
							if(si.nPos < si.nMax) si.nPos++; 
							break; 
						  case SB_THUMBPOSITION: 
							si.nPos = HIWORD(wParam); 
							break; 
						} 

          si.fMask  = SIF_POS; 
          SetScrollInfo((HWND)lParam, SB_CTL, &si, TRUE); 
          SetDlgItemInt(hwndDlg, IDC_EDIT1, si.nPos, FALSE); 

		  return TRUE;
	}

		case WM_COMMAND:
		{
			WORD wID;
			wID = LOWORD(wParam);

            //switch (wID)
			//{
			//
			//}
		}
		break;


		default:
			break;
	}

	return FALSE;
}

/*----------------------------------------------------------------------------------------------*/
int CALLBACK DisplayPropertySheet_DialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{

	switch (uMsg)
	{
		case WM_INITDIALOG:
		{
			HWND hComboView;
			hComboView = GetDlgItem(hwndDlg,IDC_COMBO_DISPLAYMODE);
			SendMessage(hComboView,CB_ADDSTRING,0, (LPARAM)"6- 1920*1080");
			SendMessage(hComboView,CB_ADDSTRING,0, (LPARAM)"5- 1920*1200");
			SendMessage(hComboView,CB_ADDSTRING,0, (LPARAM)"4- 1600*1200");
			SendMessage(hComboView,CB_ADDSTRING,0, (LPARAM)"3- 1280*800");
			SendMessage(hComboView,CB_ADDSTRING,0, (LPARAM)"2- 1024*768");
			SendMessage(hComboView,CB_ADDSTRING,0, (LPARAM)"1- 800*600");

			if (AppData.FullScreenWidth == 800) { SendMessage(hComboView, CB_SETCURSEL, (WPARAM)0, (LPARAM)0); }
			else if (AppData.FullScreenWidth == 1024) { SendMessage(hComboView, CB_SETCURSEL, (WPARAM)1, (LPARAM)0); }
			else if (AppData.FullScreenWidth == 1280) { SendMessage(hComboView, CB_SETCURSEL, (WPARAM)2, (LPARAM)0); }
			else if (AppData.FullScreenWidth == 1600) { SendMessage(hComboView, CB_SETCURSEL, (WPARAM)3, (LPARAM)0); }
			else if ((AppData.FullScreenWidth == 1920) && (AppData.FullScreenHeight == 1200) ){ SendMessage(hComboView, CB_SETCURSEL, (WPARAM)4, (LPARAM)0); }
			else if (AppData.FullScreenWidth == 1920) { SendMessage(hComboView, CB_SETCURSEL, (WPARAM)4, (LPARAM)0); }

			if (AppData.FakeFS) CheckDlgButton(hwndDlg, ID_CHECK_FAKEFS, BST_CHECKED);

		}
		break;
		case WM_COMMAND:
		{
			WORD wID;
			wID = LOWORD(wParam);

			switch (wID)
			{

			
			}
		}
		break;

		default:
			break;
	}

	return FALSE;
}

/*----------------------------------------------------------------------------------------------*/
int CALLBACK AudioPropertySheet_DialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{

	switch (uMsg)
	{
		case WM_INITDIALOG:
		{
			HWND htb;

			htb = GetDlgItem(hwndDlg, IDC_MASTER_VOLUME); 
			SendMessage(htb, TBM_SETRANGE,FALSE, MAKELONG(0, 100));
			//SendMessage(htb, TBM_SETSEL,FALSE, MAKELONG(1, 2));
			SendMessage(htb, TBM_SETTICFREQ, 10, 0);
			SendMessage(htb, TBM_SETPOS,TRUE, Get_Master_Volume()); 

		}
		break;
		case WM_COMMAND:
		{
			WORD wID;
			wID = LOWORD(wParam);

			//switch (wID)
			//{
			//
			//}
		}
		break;

		default:
			break;
	}

	return FALSE;
}

/*----------------------------------------------------------------------------------------------*/
int CALLBACK HackPropertySheet_DialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{

	switch (uMsg)
	{
		case WM_INITDIALOG:
		{
			if (SpeedDrive) CheckDlgButton(hwndDlg, IDC_FAST_DRIVE, BST_CHECKED);
			if (Hack_Synchrosound) CheckDlgButton(hwndDlg, IDC_CHECK_HACKSYNCSOUND, BST_CHECKED);
			if (Parados_enabled) CheckDlgButton(hwndDlg, IDC_PARADOS, BST_CHECKED);

		}
		break;
		case WM_COMMAND:
		{
			WORD wID;
			wID = LOWORD(wParam);

			//switch (wID)
			//{
			//
			//}
		}
		break;

		default:
			break;
	}

	return FALSE;
}

/*-----------------------------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------------------------*/


#define NBRETAB 4
static HWND			m_aChildTab[NBRETAB];	

void UpdateChildTab(HWND hDlg)
{
	int i;
	// afficher le dialogue correspondant  l'onglet slectionn et masquer les autres
	HWND hTabCtrl = GetDlgItem(hDlg, IDC_TABCTRL);
	int nSelected = SendMessage(hTabCtrl, TCM_GETCURSEL, 0, 0);
	for(i = 0; i < NBRETAB; i++)
		ShowWindow(m_aChildTab[i], (i==nSelected)? SW_SHOW : SW_HIDE);
}

int MsgInitDialog(HWND hDlg)
{
	RECT rcTabCtrl;
	int i;
	HWND hTabCtrl;
	TCITEM tci;
	
	// cration des dialogues enfants
	m_aChildTab[0] = CreateDialog(AppData.AppInstance, MAKEINTRESOURCE(IDD_DIALOG_SPEED),
									hDlg, SpeedPropertySheet_DialogProc);
	m_aChildTab[1] = CreateDialog(AppData.AppInstance, MAKEINTRESOURCE(IDD_DIALOG_DISPLAY),
									hDlg, DisplayPropertySheet_DialogProc);
	m_aChildTab[2] = CreateDialog(AppData.AppInstance, MAKEINTRESOURCE(IDD_DIALOG_AUDIO),
									hDlg, AudioPropertySheet_DialogProc);
	m_aChildTab[3] = CreateDialog(AppData.AppInstance, MAKEINTRESOURCE(IDD_DIALOG_HACK),
									hDlg, HackPropertySheet_DialogProc);

	// ajout des onglets
	hTabCtrl = GetDlgItem(hDlg, IDC_TABCTRL);
	
	tci.mask = TCIF_TEXT;
	tci.pszText = "Speed";
	SendMessage(hTabCtrl, TCM_INSERTITEM, 0, (LPARAM) &tci);
	tci.pszText = "Display";
	SendMessage(hTabCtrl, TCM_INSERTITEM, 1, (LPARAM) &tci);
	tci.pszText = "Audio";
	SendMessage(hTabCtrl, TCM_INSERTITEM, 2, (LPARAM) &tci);
	tci.pszText = "Hack";
	SendMessage(hTabCtrl, TCM_INSERTITEM, 3, (LPARAM) &tci);
	
	// dtermination du rectangle o placer les dialogues enfants  partir du rectangle
	// du tabctrl, conversion dans le systemde coordonne de la bote de dialogue parente
	
	GetWindowRect(hTabCtrl, &rcTabCtrl);
	SendMessage(hTabCtrl, TCM_ADJUSTRECT, FALSE, (LPARAM) &rcTabCtrl);
	MapWindowPoints(NULL, hDlg, (LPPOINT) &rcTabCtrl, 2);

	// on place les dialogue enfants au centre de ce rectangle
	for(i = 0; i < NBRETAB; i++)
	{
		// taille du dialogue enfant
		RECT rcChildTab;
		int x,y;
		GetWindowRect(m_aChildTab[i], &rcChildTab);
		x = (rcTabCtrl.left+rcTabCtrl.right)/2 - (rcChildTab.right-rcChildTab.left)/2;
		y = (rcTabCtrl.top+rcTabCtrl.bottom)/2 - (rcChildTab.bottom-rcChildTab.top)/2;
		SetWindowPos(m_aChildTab[i], NULL, x, y, 0, 0, SWP_NOZORDER|SWP_NOSIZE|SWP_NOREDRAW);
	}

	// affichage de l'onglet un et mise  jour
	SendMessage(hTabCtrl, TCM_SETCURSEL, 0, 0);
	UpdateChildTab(hDlg);
	return TRUE;
}

int CALLBACK OptionDlgProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
		case WM_INITDIALOG :
			return MsgInitDialog(hDlg);
		case WM_DESTROY :
		{
			// destruction des dialogues enfants
			DestroyWindow(m_aChildTab[0]);
			DestroyWindow(m_aChildTab[1]);
			DestroyWindow(m_aChildTab[2]);
			DestroyWindow(m_aChildTab[3]);
			return 0;
		}
		case WM_NOTIFY :
		{
			// mise  jour de l'affichage des dialogues enfants
			LPNMHDR lpnmhdr = (LPNMHDR) lParam;
			if(lpnmhdr->code == TCN_SELCHANGE)
				UpdateChildTab(hDlg);
			return 0;
		}
		case WM_COMMAND :
		{
			// fermeture de la bote de dialogue
			int nIDCtrl = LOWORD(wParam);
			switch(nIDCtrl)
			{
			case IDOK:
				{
					HWND htb;
					char v[3];
					int s;

					//Save all
					if(IsDlgButtonChecked(m_aChildTab[0], IDC_CHECK_REALTIME) == BST_CHECKED) { Host_LockSpeed = TRUE; } else { Host_LockSpeed = FALSE; }
					if(IsDlgButtonChecked(m_aChildTab[0], IDC_CHECK_SLOWDOWN) == BST_CHECKED) { Slowdown = TRUE; } else { Slowdown = FALSE; }

					if (IsDlgButtonChecked(m_aChildTab[1], ID_CHECK_FAKEFS) == BST_CHECKED) { AppData.FakeFS = TRUE; } else { AppData.FakeFS = FALSE; }

					if(IsDlgButtonChecked(m_aChildTab[3], IDC_CHECK_HACKSYNCSOUND) == BST_CHECKED) { Hack_Synchrosound = TRUE; } else { Hack_Synchrosound = FALSE; }
					if(IsDlgButtonChecked(m_aChildTab[3], IDC_FAST_DRIVE) == BST_CHECKED) { SpeedDrive = TRUE; } else { SpeedDrive = FALSE; }
					if(IsDlgButtonChecked(m_aChildTab[3], IDC_PARADOS) == BST_CHECKED) { Parados_enabled = TRUE; } else { Parados_enabled = FALSE; }

					GetDlgItemText(m_aChildTab[0], IDC_EDIT1, v, 2);
					CPC_SetFrameSkip(atoi(v));

					htb = GetDlgItem(m_aChildTab[0], IDC_BOOST_Z80);
					BoostZ80 = (short)SendMessage(htb, TBM_GETPOS, 0, 0);

					htb = GetDlgItem(m_aChildTab[2], IDC_MASTER_VOLUME);
					Set_Master_Volume((short)SendMessage(htb, TBM_GETPOS, 0, 0));

					htb = GetDlgItem(m_aChildTab[1], IDC_COMBO_DISPLAYMODE);
					s = SendMessage(htb,CB_GETCURSEL ,0, 0);
					if (s > -1)
					{
						switch (s)
						{
							case 0:
								AppData.FullScreenWidth=800;
								AppData.FullScreenHeight=600;
							break;
							case 1:
								AppData.FullScreenWidth=1024;
								AppData.FullScreenHeight=768;
							break;
							case 2:
								AppData.FullScreenWidth=1280;
								AppData.FullScreenHeight=800;
							break;
							case 3:
								AppData.FullScreenWidth=1600;
								AppData.FullScreenHeight=1200;
							break;
							case 4:
								AppData.FullScreenWidth=1920;
								AppData.FullScreenHeight=1200;
							break;
						}
					}


					EndDialog(hDlg, IDOK);
				}
				break;
			case IDCANCEL:
				{
					EndDialog(hDlg, IDCANCEL);
				}
				break;
			}
			return 0;
		}
	}
	return 0;
}


void Options_PropertySheet(HWND hwndParent)
{
	DialogBox(AppData.AppInstance, MAKEINTRESOURCE(IDD_DIALOG_OPTION), NULL, OptionDlgProc);
}